import argparse

from utils.util import seed_set
from dsl_design.autodsl import autodsl
# from planning.planning import planning

parser = argparse.ArgumentParser()
parser.add_argument('--module', default='autodsl')
parser.add_argument('--mode', default='operation')
parser.add_argument('--seed', type=int, default=42)
parser.add_argument('--demo', action='store_true', default=False)
parser.add_argument("--origin", default="dataset/original_protocol/")
parser.add_argument("--data", default="dsl_design/data/")
parser.add_argument("--domain", default="Genetics")
parser.add_argument("--task", default="planning")
args = parser.parse_args()

seed_set(args.seed)

# python main.py --module autodsl --domain Ecology --mode operation
# python main.py --module planning --domain Ecology --task planning
if __name__ == "__main__":
    if args.module == "autodsl":
        autodsl(args)
    # elif args.module == "planning":
    #     planning(args)